/**
 * https://developer.community.boschrexroth.com/t5/Store-and-How-to/Using-REST-API-of-ctrlX-CORE/ba-p/12490
 */

const server = '192.168.1.30';
const username = "boschrexroth";
const password = "boschrexroth";

let token = "";

async function auth()
{
    let data = {
        name: username,
        password: password
    };

    let request = await fetch(`https://${server}/identity-manager/api/v1/auth/token`, {
        method: "POST",
        headers: {    
            "Content-Type": "application/json",
        },
        body: JSON.stringify(data)
    });

    let response = await request.json();

    token = response.access_token;

    console.log(token);

    let value = await read('plc/app/Application/sym/PLC_PRG/Counter');

    await subscribe();
}

async function read(node)
{
    let request = await fetch(`https://${server}/automation/api/v2/nodes/${node}?type=null`, {
       method: "GET",
       headers: {    
        "Content-Type": "application/json",
        'Authorization': `Bearer ${token}`, 
        }
    });

    let response = await request.json();

    console.log(response);

    return response;
}

async function subscribe()
{
    let id = "subscription_" + Math.floor(Math.random() * 100000);

    let data = { 
        "properties": { 
            "id": id, 
            "publishInterval": 1000, 
            "keepaliveInterval": 30000 }, 
            "nodes": [
                "plc/app/Application/sym/PLC_PRG/Counter", 
                "plc/app/Application/sym/PLC_PRG/Reset"] 
    }

    let request = await fetch(`https://${server}/automation/api/v2/events`, {
        method: "POST",
        headers: {    
            "Content-Type": "application/json",
            'Authorization': `Bearer ${token}`, 
        },
        body: JSON.stringify(data)
    });

    if(!request.ok) return false;

    let response = await request.text();

    let listener = function(event) {
        console.log(event);
    }

    const es = new EventSourcePolyfill(`https://${server}/automation/api/v2/events/${id}`, {
        headers: {
            'Authorization': `Bearer ${token}`, 
        }
    });    
    
    es.addEventListener("open", listener);
    es.addEventListener("message", listener);
    es.addEventListener("error", listener);

}


async function main()
{
    await auth();

}

main();




// plc/app/Application/sym/PLC_PRG/Counter