#!/usr/bin/env python
# coding: utf-8

# In[ ]:


#!/usr/bin/env python3
import sys 
import os

sys.path.append(os.environ['SNAP_DATA'])

import faulthandler
import time
from scipy.interpolate import interp1d
import numpy as np
from scipy import signal
import random
import ctrlxdatalayer
from app.call_datalayer_client import CallDataLayerClient 
from ctrlxdatalayer.variant import Result, Variant, VariantType

import requests
import json
#https://192.168.1.1/influxdb/
_TOKEN_IFDB="DmJe5y5k0HqRpTbTz2EifeP1Ngjg9cj8A3yApJ00Gm6ZJbNXFbkMIDzxCzZnz9apbIXbvcPdvRrC-ecHp4jaZQ=="
measurement='ArrayLoader'
bucket='boschrexroth'
org='boschrexroth'
sleeptime=1

datalayer_client, connection_string = CallDataLayerClient.get_client(ip="192.168.1.1", user="boschrexroth", password="boschrexroth",ssl_port=443)  #place here the needer info
print("INFO Creating Python Data Layer Client instance")
calldatalayerclient = CallDataLayerClient(datalayer_client)
calldatalayerclient.setRootNode("")
############## Downsample ########################################
def downsample(array, npts):
    interpolated = interp1d(np.arange(len(array)), array, axis = 0, fill_value = 'extrapolate')
    downsampled = interpolated(np.linspace(0, len(array), npts))
    
    return downsampled

############## InfluxDB ##########################################        
def downsampleArray(array, maxNumPoints):
    interpolated = interp1d(np.arange(len(array)), array, axis = 0, fill_value = 'extrapolate')
    downsampled = interpolated(np.linspace(0, len(array), npts))
    print(downsampled)
    return downsampled

def pushArrayToInflux(array, ts_nanoseconds,measurement,value,token,bucket,org,verify=False,timeshift_sec=0,ipaddress='http://localhost:8086/'):
    mytime=round(time.time()*1000)*1000000 + timeshift_sec*1000000000
    #lines=[]
    lines=""
    for sl in range(len(array)):
        recordtime =mytime + sl*ts_nanoseconds;
        element = array[sl]
        line = measurement+' '+value+'='+str(element) + ' ' + str(recordtime)+ '\n'
        lines=lines+line
    url = ipaddress+"api/v2/write?org="+org+"&bucket="+bucket+"&precision=ns"
    print(url)
    headers = {"Content-Type": "text/plain", "Authorization": "Token "+token }
    try: 
        response = requests.post(url, headers=headers, data=lines, verify=verify)
        print("Status Code", response.status_code)
        print("JSON Response ", response.content)
        return response.status_code,response.content
    except:
        print("something is wrong")
        return("error")
              

def pushValueToInflux(element,measurement,value,token,bucket,org,verify=False,timeshift_sec=0,ipaddress='http://localhost:8086/'):
    mytime=round(time.time()*1000)*1000000 + timeshift_sec*1000000000

    line = measurement+' '+value+'='+str(element) + ' ' + str(mytime)
    url = ipaddress+"api/v2/write?org="+org+"&bucket="+bucket+"&precision=ns"
    headers = {"Content-Type": "text/plain", "Authorization": "Token "+token }
    response = requests.post(url, headers=headers, data=line, verify=verify)

    print("Status Code", response.status_code)
    print("JSON Response ", response.content)


    
#################################### APP #######################################            
if __name__ == '__main__':
    
    faulthandler.enable()
    #time.sleep(10)
    calldatalayerclient.auth_token()
    calldatalayerclient.ping()
    
    #check dapatalyer node presence 
    i,mytype=calldatalayerclient.browse("plc/app/Application/sym/PLC_PRG")
    print(i)
    while('A' not in i):
        print('no_node_present')
        time.sleep(10)
        i,mytype=calldatalayerclient.browse("devices")
        print(i)
    print('Node_found')    

    with datalayer_client: # datalayer_client is closed automatically when leaving with block
        while datalayer_client.is_connected():
            
            st = time.time() 

            i,mytype=calldatalayerclient.read_sync("plc/app/Application/sym/PLC_PRG/A")
            print(i)
            print('\n')
            print("my Array length is", len(i))
            print(mytype)

            arr = np.array(i)
            downsampled_y = downsample(arr, 30000)
            myTS=1000000
            pushArrayToInflux(arr,myTS,measurement,"MyArray1",_TOKEN_IFDB,bucket,org,ipaddress='https://192.168.1.1/influxdb/')    


            et = time.time()

            # get the execution time
            elapsed_time = et - st
            print('Execution time:', elapsed_time, 'seconds')
            time.sleep(15.0)
            
                          

  
            time.sleep(sleeptime)

    print("INFO Stopping Data Layer system")
    stop_ok = CallDataLayerClient.stop()   # Attention: Doesn't return if any provider or client instance is still runnning
    print("System Stop", stop_ok)

    


# In[ ]:




