from xml.etree.ElementTree import tostring
from flask import Flask
from flask_cors import CORS
import os

app = Flask(__name__,
            static_url_path='', 
            static_folder='Resources/')

CORS(app)

dir_path = 'Resources/'


@app.route('/directories')
def directories():
    dirs = []
    try:
        for path in os.scandir(dir_path):
            if path.is_dir():
                print(path.name)
                dirs.append(str(path.name))
        return dirs
    except Exception as e:
        print(e)


@app.route('/fileCount/<target>/<folder>')
def fileCount(target = None, folder = None):
    print(dir_path + target +'/' + folder)
    count = 0
    try:
        for path in os.scandir(dir_path + target +'/' + folder):
            if path.is_file():
                count += 1
        return str(count)
    except Exception as e:
        print(e)

app.run(host="192.168.1.2")
