// automatically generated by the FlatBuffers compiler, do not modify


#ifndef FLATBUFFERS_GENERATED_PROGRAMTASK_COMM_DATALAYER_H_
#define FLATBUFFERS_GENERATED_PROGRAMTASK_COMM_DATALAYER_H_

#include "flatbuffers/flatbuffers.h"

// Ensure the included flatbuffers.h is the same version as when this file was
// generated, otherwise it may not be compatible.
static_assert(FLATBUFFERS_VERSION_MAJOR == 23 &&
              FLATBUFFERS_VERSION_MINOR == 1 &&
              FLATBUFFERS_VERSION_REVISION == 4,
             "Non-compatible flatbuffers version included");

#include "diagnosis_generated.h"

namespace comm {
namespace datalayer {

struct ProgressData;
struct ProgressDataBuilder;
struct ProgressDataT;

struct ProgramTask;
struct ProgramTaskBuilder;
struct ProgramTaskT;

enum ProgramTaskState : int8_t {
  /// task is pending and not been started
  ProgramTaskState_pending = 0,
  /// task finished with failure
  ProgramTaskState_failed = 1,
  /// task is successfully done
  ProgramTaskState_done = 2,
  /// task is running
  ProgramTaskState_running = 3,
  ProgramTaskState_MIN = ProgramTaskState_pending,
  ProgramTaskState_MAX = ProgramTaskState_running
};

inline const ProgramTaskState (&EnumValuesProgramTaskState())[4] {
  static const ProgramTaskState values[] = {
    ProgramTaskState_pending,
    ProgramTaskState_failed,
    ProgramTaskState_done,
    ProgramTaskState_running
  };
  return values;
}

inline const char * const *EnumNamesProgramTaskState() {
  static const char * const names[5] = {
    "pending",
    "failed",
    "done",
    "running",
    nullptr
  };
  return names;
}

inline const char *EnumNameProgramTaskState(ProgramTaskState e) {
  if (::flatbuffers::IsOutRange(e, ProgramTaskState_pending, ProgramTaskState_running)) return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesProgramTaskState()[index];
}

struct ProgressDataT : public ::flatbuffers::NativeTable {
  typedef ProgressData TableType;
  std::string key{};
  std::string value{};
};

struct ProgressData FLATBUFFERS_FINAL_CLASS : private ::flatbuffers::Table {
  typedef ProgressDataT NativeTableType;
  typedef ProgressDataBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_KEY = 4,
    VT_VALUE = 6
  };
  const ::flatbuffers::String *key() const {
    return GetPointer<const ::flatbuffers::String *>(VT_KEY);
  }
  ::flatbuffers::String *mutable_key() {
    return GetPointer<::flatbuffers::String *>(VT_KEY);
  }
  bool KeyCompareLessThan(const ProgressData * const o) const {
    return *key() < *o->key();
  }
  int KeyCompareWithValue(const char *_key) const {
    return strcmp(key()->c_str(), _key);
  }
  /// corresponding value
  const ::flatbuffers::String *value() const {
    return GetPointer<const ::flatbuffers::String *>(VT_VALUE);
  }
  ::flatbuffers::String *mutable_value() {
    return GetPointer<::flatbuffers::String *>(VT_VALUE);
  }
  bool Verify(::flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffsetRequired(verifier, VT_KEY) &&
           verifier.VerifyString(key()) &&
           VerifyOffset(verifier, VT_VALUE) &&
           verifier.VerifyString(value()) &&
           verifier.EndTable();
  }
  ProgressDataT *UnPack(const ::flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(ProgressDataT *_o, const ::flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static ::flatbuffers::Offset<ProgressData> Pack(::flatbuffers::FlatBufferBuilder &_fbb, const ProgressDataT* _o, const ::flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct ProgressDataBuilder {
  typedef ProgressData Table;
  ::flatbuffers::FlatBufferBuilder &fbb_;
  ::flatbuffers::uoffset_t start_;
  void add_key(::flatbuffers::Offset<::flatbuffers::String> key) {
    fbb_.AddOffset(ProgressData::VT_KEY, key);
  }
  void add_value(::flatbuffers::Offset<::flatbuffers::String> value) {
    fbb_.AddOffset(ProgressData::VT_VALUE, value);
  }
  explicit ProgressDataBuilder(::flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ::flatbuffers::Offset<ProgressData> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = ::flatbuffers::Offset<ProgressData>(end);
    fbb_.Required(o, ProgressData::VT_KEY);
    return o;
  }
};

inline ::flatbuffers::Offset<ProgressData> CreateProgressData(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    ::flatbuffers::Offset<::flatbuffers::String> key = 0,
    ::flatbuffers::Offset<::flatbuffers::String> value = 0) {
  ProgressDataBuilder builder_(_fbb);
  builder_.add_value(value);
  builder_.add_key(key);
  return builder_.Finish();
}

inline ::flatbuffers::Offset<ProgressData> CreateProgressDataDirect(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    const char *key = nullptr,
    const char *value = nullptr) {
  auto key__ = key ? _fbb.CreateString(key) : 0;
  auto value__ = value ? _fbb.CreateString(value) : 0;
  return comm::datalayer::CreateProgressData(
      _fbb,
      key__,
      value__);
}

::flatbuffers::Offset<ProgressData> CreateProgressData(::flatbuffers::FlatBufferBuilder &_fbb, const ProgressDataT *_o, const ::flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct ProgramTaskT : public ::flatbuffers::NativeTable {
  typedef ProgramTask TableType;
  std::string id{};
  comm::datalayer::ProgramTaskState state = comm::datalayer::ProgramTaskState_pending;
  uint32_t progress = 0;
  std::unique_ptr<comm::datalayer::DiagnosisT> result{};
  std::string progressInfo{};
  std::vector<std::unique_ptr<comm::datalayer::ProgressDataT>> progressData{};
  ProgramTaskT() = default;
  ProgramTaskT(const ProgramTaskT &o);
  ProgramTaskT(ProgramTaskT&&) FLATBUFFERS_NOEXCEPT = default;
  ProgramTaskT &operator=(ProgramTaskT o) FLATBUFFERS_NOEXCEPT;
};

struct ProgramTask FLATBUFFERS_FINAL_CLASS : private ::flatbuffers::Table {
  typedef ProgramTaskT NativeTableType;
  typedef ProgramTaskBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_ID = 4,
    VT_STATE = 6,
    VT_PROGRESS = 8,
    VT_RESULT = 10,
    VT_PROGRESSINFO = 12,
    VT_PROGRESSDATA = 14
  };
  /// id of the task
  const ::flatbuffers::String *id() const {
    return GetPointer<const ::flatbuffers::String *>(VT_ID);
  }
  ::flatbuffers::String *mutable_id() {
    return GetPointer<::flatbuffers::String *>(VT_ID);
  }
  bool KeyCompareLessThan(const ProgramTask * const o) const {
    return *id() < *o->id();
  }
  int KeyCompareWithValue(const char *_id) const {
    return strcmp(id()->c_str(), _id);
  }
  /// state of the task
  comm::datalayer::ProgramTaskState state() const {
    return static_cast<comm::datalayer::ProgramTaskState>(GetField<int8_t>(VT_STATE, 0));
  }
  bool mutate_state(comm::datalayer::ProgramTaskState _state = static_cast<comm::datalayer::ProgramTaskState>(0)) {
    return SetField<int8_t>(VT_STATE, static_cast<int8_t>(_state), 0);
  }
  /// Progress of the task in percent, if it's not possible to calculate, set state to running and progress to 0
  uint32_t progress() const {
    return GetField<uint32_t>(VT_PROGRESS, 0);
  }
  bool mutate_progress(uint32_t _progress = 0) {
    return SetField<uint32_t>(VT_PROGRESS, _progress, 0);
  }
  /// result of task;
  const comm::datalayer::Diagnosis *result() const {
    return GetPointer<const comm::datalayer::Diagnosis *>(VT_RESULT);
  }
  comm::datalayer::Diagnosis *mutable_result() {
    return GetPointer<comm::datalayer::Diagnosis *>(VT_RESULT);
  }
  /// Additional progress information
  const ::flatbuffers::String *progressInfo() const {
    return GetPointer<const ::flatbuffers::String *>(VT_PROGRESSINFO);
  }
  ::flatbuffers::String *mutable_progressInfo() {
    return GetPointer<::flatbuffers::String *>(VT_PROGRESSINFO);
  }
  /// Additional progress information as key value pair
  const ::flatbuffers::Vector<::flatbuffers::Offset<comm::datalayer::ProgressData>> *progressData() const {
    return GetPointer<const ::flatbuffers::Vector<::flatbuffers::Offset<comm::datalayer::ProgressData>> *>(VT_PROGRESSDATA);
  }
  ::flatbuffers::Vector<::flatbuffers::Offset<comm::datalayer::ProgressData>> *mutable_progressData() {
    return GetPointer<::flatbuffers::Vector<::flatbuffers::Offset<comm::datalayer::ProgressData>> *>(VT_PROGRESSDATA);
  }
  bool Verify(::flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffsetRequired(verifier, VT_ID) &&
           verifier.VerifyString(id()) &&
           VerifyField<int8_t>(verifier, VT_STATE, 1) &&
           VerifyField<uint32_t>(verifier, VT_PROGRESS, 4) &&
           VerifyOffset(verifier, VT_RESULT) &&
           verifier.VerifyTable(result()) &&
           VerifyOffset(verifier, VT_PROGRESSINFO) &&
           verifier.VerifyString(progressInfo()) &&
           VerifyOffset(verifier, VT_PROGRESSDATA) &&
           verifier.VerifyVector(progressData()) &&
           verifier.VerifyVectorOfTables(progressData()) &&
           verifier.EndTable();
  }
  ProgramTaskT *UnPack(const ::flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(ProgramTaskT *_o, const ::flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static ::flatbuffers::Offset<ProgramTask> Pack(::flatbuffers::FlatBufferBuilder &_fbb, const ProgramTaskT* _o, const ::flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct ProgramTaskBuilder {
  typedef ProgramTask Table;
  ::flatbuffers::FlatBufferBuilder &fbb_;
  ::flatbuffers::uoffset_t start_;
  void add_id(::flatbuffers::Offset<::flatbuffers::String> id) {
    fbb_.AddOffset(ProgramTask::VT_ID, id);
  }
  void add_state(comm::datalayer::ProgramTaskState state) {
    fbb_.AddElement<int8_t>(ProgramTask::VT_STATE, static_cast<int8_t>(state), 0);
  }
  void add_progress(uint32_t progress) {
    fbb_.AddElement<uint32_t>(ProgramTask::VT_PROGRESS, progress, 0);
  }
  void add_result(::flatbuffers::Offset<comm::datalayer::Diagnosis> result) {
    fbb_.AddOffset(ProgramTask::VT_RESULT, result);
  }
  void add_progressInfo(::flatbuffers::Offset<::flatbuffers::String> progressInfo) {
    fbb_.AddOffset(ProgramTask::VT_PROGRESSINFO, progressInfo);
  }
  void add_progressData(::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<comm::datalayer::ProgressData>>> progressData) {
    fbb_.AddOffset(ProgramTask::VT_PROGRESSDATA, progressData);
  }
  explicit ProgramTaskBuilder(::flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ::flatbuffers::Offset<ProgramTask> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = ::flatbuffers::Offset<ProgramTask>(end);
    fbb_.Required(o, ProgramTask::VT_ID);
    return o;
  }
};

inline ::flatbuffers::Offset<ProgramTask> CreateProgramTask(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    ::flatbuffers::Offset<::flatbuffers::String> id = 0,
    comm::datalayer::ProgramTaskState state = comm::datalayer::ProgramTaskState_pending,
    uint32_t progress = 0,
    ::flatbuffers::Offset<comm::datalayer::Diagnosis> result = 0,
    ::flatbuffers::Offset<::flatbuffers::String> progressInfo = 0,
    ::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<comm::datalayer::ProgressData>>> progressData = 0) {
  ProgramTaskBuilder builder_(_fbb);
  builder_.add_progressData(progressData);
  builder_.add_progressInfo(progressInfo);
  builder_.add_result(result);
  builder_.add_progress(progress);
  builder_.add_id(id);
  builder_.add_state(state);
  return builder_.Finish();
}

inline ::flatbuffers::Offset<ProgramTask> CreateProgramTaskDirect(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    const char *id = nullptr,
    comm::datalayer::ProgramTaskState state = comm::datalayer::ProgramTaskState_pending,
    uint32_t progress = 0,
    ::flatbuffers::Offset<comm::datalayer::Diagnosis> result = 0,
    const char *progressInfo = nullptr,
    std::vector<::flatbuffers::Offset<comm::datalayer::ProgressData>> *progressData = nullptr) {
  auto id__ = id ? _fbb.CreateString(id) : 0;
  auto progressInfo__ = progressInfo ? _fbb.CreateString(progressInfo) : 0;
  auto progressData__ = progressData ? _fbb.CreateVectorOfSortedTables<comm::datalayer::ProgressData>(progressData) : 0;
  return comm::datalayer::CreateProgramTask(
      _fbb,
      id__,
      state,
      progress,
      result,
      progressInfo__,
      progressData__);
}

::flatbuffers::Offset<ProgramTask> CreateProgramTask(::flatbuffers::FlatBufferBuilder &_fbb, const ProgramTaskT *_o, const ::flatbuffers::rehasher_function_t *_rehasher = nullptr);

inline ProgressDataT *ProgressData::UnPack(const ::flatbuffers::resolver_function_t *_resolver) const {
  auto _o = std::unique_ptr<ProgressDataT>(new ProgressDataT());
  UnPackTo(_o.get(), _resolver);
  return _o.release();
}

inline void ProgressData::UnPackTo(ProgressDataT *_o, const ::flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  { auto _e = key(); if (_e) _o->key = _e->str(); }
  { auto _e = value(); if (_e) _o->value = _e->str(); }
}

inline ::flatbuffers::Offset<ProgressData> ProgressData::Pack(::flatbuffers::FlatBufferBuilder &_fbb, const ProgressDataT* _o, const ::flatbuffers::rehasher_function_t *_rehasher) {
  return CreateProgressData(_fbb, _o, _rehasher);
}

inline ::flatbuffers::Offset<ProgressData> CreateProgressData(::flatbuffers::FlatBufferBuilder &_fbb, const ProgressDataT *_o, const ::flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs { ::flatbuffers::FlatBufferBuilder *__fbb; const ProgressDataT* __o; const ::flatbuffers::rehasher_function_t *__rehasher; } _va = { &_fbb, _o, _rehasher}; (void)_va;
  auto _key = _fbb.CreateString(_o->key);
  auto _value = _o->value.empty() ? 0 : _fbb.CreateString(_o->value);
  return comm::datalayer::CreateProgressData(
      _fbb,
      _key,
      _value);
}

inline ProgramTaskT::ProgramTaskT(const ProgramTaskT &o)
      : id(o.id),
        state(o.state),
        progress(o.progress),
        result((o.result) ? new comm::datalayer::DiagnosisT(*o.result) : nullptr),
        progressInfo(o.progressInfo) {
  progressData.reserve(o.progressData.size());
  for (const auto &progressData_ : o.progressData) { progressData.emplace_back((progressData_) ? new comm::datalayer::ProgressDataT(*progressData_) : nullptr); }
}

inline ProgramTaskT &ProgramTaskT::operator=(ProgramTaskT o) FLATBUFFERS_NOEXCEPT {
  std::swap(id, o.id);
  std::swap(state, o.state);
  std::swap(progress, o.progress);
  std::swap(result, o.result);
  std::swap(progressInfo, o.progressInfo);
  std::swap(progressData, o.progressData);
  return *this;
}

inline ProgramTaskT *ProgramTask::UnPack(const ::flatbuffers::resolver_function_t *_resolver) const {
  auto _o = std::unique_ptr<ProgramTaskT>(new ProgramTaskT());
  UnPackTo(_o.get(), _resolver);
  return _o.release();
}

inline void ProgramTask::UnPackTo(ProgramTaskT *_o, const ::flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  { auto _e = id(); if (_e) _o->id = _e->str(); }
  { auto _e = state(); _o->state = _e; }
  { auto _e = progress(); _o->progress = _e; }
  { auto _e = result(); if (_e) { if(_o->result) { _e->UnPackTo(_o->result.get(), _resolver); } else { _o->result = std::unique_ptr<comm::datalayer::DiagnosisT>(_e->UnPack(_resolver)); } } else if (_o->result) { _o->result.reset(); } }
  { auto _e = progressInfo(); if (_e) _o->progressInfo = _e->str(); }
  { auto _e = progressData(); if (_e) { _o->progressData.resize(_e->size()); for (::flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { if(_o->progressData[_i]) { _e->Get(_i)->UnPackTo(_o->progressData[_i].get(), _resolver); } else { _o->progressData[_i] = std::unique_ptr<comm::datalayer::ProgressDataT>(_e->Get(_i)->UnPack(_resolver)); }; } } else { _o->progressData.resize(0); } }
}

inline ::flatbuffers::Offset<ProgramTask> ProgramTask::Pack(::flatbuffers::FlatBufferBuilder &_fbb, const ProgramTaskT* _o, const ::flatbuffers::rehasher_function_t *_rehasher) {
  return CreateProgramTask(_fbb, _o, _rehasher);
}

inline ::flatbuffers::Offset<ProgramTask> CreateProgramTask(::flatbuffers::FlatBufferBuilder &_fbb, const ProgramTaskT *_o, const ::flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs { ::flatbuffers::FlatBufferBuilder *__fbb; const ProgramTaskT* __o; const ::flatbuffers::rehasher_function_t *__rehasher; } _va = { &_fbb, _o, _rehasher}; (void)_va;
  auto _id = _fbb.CreateString(_o->id);
  auto _state = _o->state;
  auto _progress = _o->progress;
  auto _result = _o->result ? CreateDiagnosis(_fbb, _o->result.get(), _rehasher) : 0;
  auto _progressInfo = _o->progressInfo.empty() ? 0 : _fbb.CreateString(_o->progressInfo);
  auto _progressData = _o->progressData.size() ? _fbb.CreateVector<::flatbuffers::Offset<comm::datalayer::ProgressData>> (_o->progressData.size(), [](size_t i, _VectorArgs *__va) { return CreateProgressData(*__va->__fbb, __va->__o->progressData[i].get(), __va->__rehasher); }, &_va ) : 0;
  return comm::datalayer::CreateProgramTask(
      _fbb,
      _id,
      _state,
      _progress,
      _result,
      _progressInfo,
      _progressData);
}

inline const comm::datalayer::ProgramTask *GetProgramTask(const void *buf) {
  return ::flatbuffers::GetRoot<comm::datalayer::ProgramTask>(buf);
}

inline const comm::datalayer::ProgramTask *GetSizePrefixedProgramTask(const void *buf) {
  return ::flatbuffers::GetSizePrefixedRoot<comm::datalayer::ProgramTask>(buf);
}

inline ProgramTask *GetMutableProgramTask(void *buf) {
  return ::flatbuffers::GetMutableRoot<ProgramTask>(buf);
}

inline comm::datalayer::ProgramTask *GetMutableSizePrefixedProgramTask(void *buf) {
  return ::flatbuffers::GetMutableSizePrefixedRoot<comm::datalayer::ProgramTask>(buf);
}

inline bool VerifyProgramTaskBuffer(
    ::flatbuffers::Verifier &verifier) {
  return verifier.VerifyBuffer<comm::datalayer::ProgramTask>(nullptr);
}

inline bool VerifySizePrefixedProgramTaskBuffer(
    ::flatbuffers::Verifier &verifier) {
  return verifier.VerifySizePrefixedBuffer<comm::datalayer::ProgramTask>(nullptr);
}

inline void FinishProgramTaskBuffer(
    ::flatbuffers::FlatBufferBuilder &fbb,
    ::flatbuffers::Offset<comm::datalayer::ProgramTask> root) {
  fbb.Finish(root);
}

inline void FinishSizePrefixedProgramTaskBuffer(
    ::flatbuffers::FlatBufferBuilder &fbb,
    ::flatbuffers::Offset<comm::datalayer::ProgramTask> root) {
  fbb.FinishSizePrefixed(root);
}

inline std::unique_ptr<comm::datalayer::ProgramTaskT> UnPackProgramTask(
    const void *buf,
    const ::flatbuffers::resolver_function_t *res = nullptr) {
  return std::unique_ptr<comm::datalayer::ProgramTaskT>(GetProgramTask(buf)->UnPack(res));
}

inline std::unique_ptr<comm::datalayer::ProgramTaskT> UnPackSizePrefixedProgramTask(
    const void *buf,
    const ::flatbuffers::resolver_function_t *res = nullptr) {
  return std::unique_ptr<comm::datalayer::ProgramTaskT>(GetSizePrefixedProgramTask(buf)->UnPack(res));
}

}  // namespace datalayer
}  // namespace comm

#endif  // FLATBUFFERS_GENERATED_PROGRAMTASK_COMM_DATALAYER_H_
