// automatically generated by the FlatBuffers compiler, do not modify


#ifndef FLATBUFFERS_GENERATED_PROBLEM_COMM_DATALAYER_H_
#define FLATBUFFERS_GENERATED_PROBLEM_COMM_DATALAYER_H_

#include "flatbuffers/flatbuffers.h"
#include "flatbuffers/flexbuffers.h"
#include "flatbuffers/flex_flat_util.h"

// Ensure the included flatbuffers.h is the same version as when this file was
// generated, otherwise it may not be compatible.
static_assert(FLATBUFFERS_VERSION_MAJOR == 23 &&
              FLATBUFFERS_VERSION_MINOR == 1 &&
              FLATBUFFERS_VERSION_REVISION == 4,
             "Non-compatible flatbuffers version included");

namespace comm {
namespace datalayer {

struct Problem;
struct ProblemBuilder;
struct ProblemT;

enum Severity : int8_t {
  Severity_Emergency = 0,
  Severity_Alert = 1,
  Severity_Critical = 2,
  Severity_Error = 3,
  Severity_Warning = 4,
  Severity_Notice = 5,
  Severity_Informational = 6,
  Severity_Debug = 7,
  Severity_MIN = Severity_Emergency,
  Severity_MAX = Severity_Debug
};

inline const Severity (&EnumValuesSeverity())[8] {
  static const Severity values[] = {
    Severity_Emergency,
    Severity_Alert,
    Severity_Critical,
    Severity_Error,
    Severity_Warning,
    Severity_Notice,
    Severity_Informational,
    Severity_Debug
  };
  return values;
}

inline const char * const *EnumNamesSeverity() {
  static const char * const names[9] = {
    "Emergency",
    "Alert",
    "Critical",
    "Error",
    "Warning",
    "Notice",
    "Informational",
    "Debug",
    nullptr
  };
  return names;
}

inline const char *EnumNameSeverity(Severity e) {
  if (::flatbuffers::IsOutRange(e, Severity_Emergency, Severity_Debug)) return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesSeverity()[index];
}

struct ProblemT : public ::flatbuffers::NativeTable {
  typedef Problem TableType;
  std::string type{};
  std::string title{};
  int32_t status = 0;
  std::string detail{};
  std::string instance{};
  std::string mainDiagnosisCode{};
  std::string detailedDiagnosisCode{};
  std::string dynamicDescription{};
  comm::datalayer::Severity severity = comm::datalayer::Severity_Emergency;
  std::vector<std::string> links{};
  std::string entity{};
  std::vector<uint8_t> moreInfo{};
  std::vector<std::unique_ptr<comm::datalayer::ProblemT>> cause{};
  ProblemT() = default;
  ProblemT(const ProblemT &o);
  ProblemT(ProblemT&&) FLATBUFFERS_NOEXCEPT = default;
  ProblemT &operator=(ProblemT o) FLATBUFFERS_NOEXCEPT;
};

struct Problem FLATBUFFERS_FINAL_CLASS : private ::flatbuffers::Table {
  typedef ProblemT NativeTableType;
  typedef ProblemBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_TYPE = 4,
    VT_TITLE = 6,
    VT_STATUS = 8,
    VT_DETAIL = 10,
    VT_INSTANCE = 12,
    VT_MAINDIAGNOSISCODE = 14,
    VT_DETAILEDDIAGNOSISCODE = 16,
    VT_DYNAMICDESCRIPTION = 18,
    VT_SEVERITY = 20,
    VT_LINKS = 22,
    VT_ENTITY = 24,
    VT_MOREINFO = 26,
    VT_CAUSE = 28
  };
  /// A URI reference [RFC3986] that identifies the problem type. 
  /// This specification encourages that, when dereferenced, 
  /// it provide human-readable documentation for the problem type 
  /// (e.g., using HTML [W3C.REC-html5-20141028]). When this member 
  /// is not present, its value is assumed to be "about:blank".
  const ::flatbuffers::String *type() const {
    return GetPointer<const ::flatbuffers::String *>(VT_TYPE);
  }
  ::flatbuffers::String *mutable_type() {
    return GetPointer<::flatbuffers::String *>(VT_TYPE);
  }
  /// A short, human-readable summary of the problem type. 
  /// It SHOULD NOT change from occurrence to occurrence of the problem, 
  /// except for purposes of localization (e.g., using proactive content 
  /// negotiation; see [RFC7231], Section 3.4).
  const ::flatbuffers::String *title() const {
    return GetPointer<const ::flatbuffers::String *>(VT_TITLE);
  }
  ::flatbuffers::String *mutable_title() {
    return GetPointer<::flatbuffers::String *>(VT_TITLE);
  }
  /// The HTTP status code ([RFC7231], Section 6) generated by the origin server for this occurrence of the problem.
  /// This will be added by the webserver - so you don't have to fill this field.
  int32_t status() const {
    return GetField<int32_t>(VT_STATUS, 0);
  }
  bool mutate_status(int32_t _status = 0) {
    return SetField<int32_t>(VT_STATUS, _status, 0);
  }
  /// A human-readable explanation specific to this occurrence of the problem.
  const ::flatbuffers::String *detail() const {
    return GetPointer<const ::flatbuffers::String *>(VT_DETAIL);
  }
  ::flatbuffers::String *mutable_detail() {
    return GetPointer<::flatbuffers::String *>(VT_DETAIL);
  }
  /// A URI reference that identifies the specific occurrence of the problem. It may or may not yield further information if dereferenced.
  const ::flatbuffers::String *instance() const {
    return GetPointer<const ::flatbuffers::String *>(VT_INSTANCE);
  }
  ::flatbuffers::String *mutable_instance() {
    return GetPointer<::flatbuffers::String *>(VT_INSTANCE);
  }
  /// The main diagnosis code was/is issued by the system that caused the problem.
  /// This code can be used to track down the root cause and source of the error.
  /// It can be used to search in the documentation for a solution.
  /// It SHOULD NOT change from occurrence to occurrence of the same problem.
  /// example: 080F0100
  const ::flatbuffers::String *mainDiagnosisCode() const {
    return GetPointer<const ::flatbuffers::String *>(VT_MAINDIAGNOSISCODE);
  }
  ::flatbuffers::String *mutable_mainDiagnosisCode() {
    return GetPointer<::flatbuffers::String *>(VT_MAINDIAGNOSISCODE);
  }
  /// The detailed diagnosis code issued by the system that caused the problem.
  /// This code can be used to track down the detailed cause and source of the error.
  /// It can be used to search in the documentation for a solution.
  /// The detailed diagnosis code gives additional information about the cause of the error.
  /// It SHOULD NOT change from occurrence to occurrence of the same problem.
  /// example: 00666001
  const ::flatbuffers::String *detailedDiagnosisCode() const {
    return GetPointer<const ::flatbuffers::String *>(VT_DETAILEDDIAGNOSISCODE);
  }
  ::flatbuffers::String *mutable_detailedDiagnosisCode() {
    return GetPointer<::flatbuffers::String *>(VT_DETAILEDDIAGNOSISCODE);
  }
  /// A dynamic description gives detailed information about the occurrence of a problem.
  /// It can change between different occurrences of the same error.
  /// example: value = -4.5
  const ::flatbuffers::String *dynamicDescription() const {
    return GetPointer<const ::flatbuffers::String *>(VT_DYNAMICDESCRIPTION);
  }
  ::flatbuffers::String *mutable_dynamicDescription() {
    return GetPointer<::flatbuffers::String *>(VT_DYNAMICDESCRIPTION);
  }
  /// Severity of a problem as defined RFC5424 of the Syslog standard, see https://tools.ietf.org/html/rfc5424'
  comm::datalayer::Severity severity() const {
    return static_cast<comm::datalayer::Severity>(GetField<int8_t>(VT_SEVERITY, 0));
  }
  bool mutate_severity(comm::datalayer::Severity _severity = static_cast<comm::datalayer::Severity>(0)) {
    return SetField<int8_t>(VT_SEVERITY, static_cast<int8_t>(_severity), 0);
  }
  /// Collection of links to fix the problem. E.g. links to online user manual, to an online community (using tags) or a developer chat (e.g. Slack).
  const ::flatbuffers::Vector<::flatbuffers::Offset<::flatbuffers::String>> *links() const {
    return GetPointer<const ::flatbuffers::Vector<::flatbuffers::Offset<::flatbuffers::String>> *>(VT_LINKS);
  }
  ::flatbuffers::Vector<::flatbuffers::Offset<::flatbuffers::String>> *mutable_links() {
    return GetPointer<::flatbuffers::Vector<::flatbuffers::Offset<::flatbuffers::String>> *>(VT_LINKS);
  }
  /// Resource or entity which causes the problem
  const ::flatbuffers::String *entity() const {
    return GetPointer<const ::flatbuffers::String *>(VT_ENTITY);
  }
  ::flatbuffers::String *mutable_entity() {
    return GetPointer<::flatbuffers::String *>(VT_ENTITY);
  }
  /// More information about the problem (key/value pair)
  const ::flatbuffers::Vector<uint8_t> *moreInfo() const {
    return GetPointer<const ::flatbuffers::Vector<uint8_t> *>(VT_MOREINFO);
  }
  ::flatbuffers::Vector<uint8_t> *mutable_moreInfo() {
    return GetPointer<::flatbuffers::Vector<uint8_t> *>(VT_MOREINFO);
  }
  flexbuffers::Reference moreInfo_flexbuffer_root() const {
    return flexbuffers::GetRoot(moreInfo()->Data(), moreInfo()->size());
  }
  /// Cause of the problem
  const ::flatbuffers::Vector<::flatbuffers::Offset<comm::datalayer::Problem>> *cause() const {
    return GetPointer<const ::flatbuffers::Vector<::flatbuffers::Offset<comm::datalayer::Problem>> *>(VT_CAUSE);
  }
  ::flatbuffers::Vector<::flatbuffers::Offset<comm::datalayer::Problem>> *mutable_cause() {
    return GetPointer<::flatbuffers::Vector<::flatbuffers::Offset<comm::datalayer::Problem>> *>(VT_CAUSE);
  }
  bool Verify(::flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffsetRequired(verifier, VT_TYPE) &&
           verifier.VerifyString(type()) &&
           VerifyOffsetRequired(verifier, VT_TITLE) &&
           verifier.VerifyString(title()) &&
           VerifyField<int32_t>(verifier, VT_STATUS, 4) &&
           VerifyOffset(verifier, VT_DETAIL) &&
           verifier.VerifyString(detail()) &&
           VerifyOffset(verifier, VT_INSTANCE) &&
           verifier.VerifyString(instance()) &&
           VerifyOffset(verifier, VT_MAINDIAGNOSISCODE) &&
           verifier.VerifyString(mainDiagnosisCode()) &&
           VerifyOffset(verifier, VT_DETAILEDDIAGNOSISCODE) &&
           verifier.VerifyString(detailedDiagnosisCode()) &&
           VerifyOffset(verifier, VT_DYNAMICDESCRIPTION) &&
           verifier.VerifyString(dynamicDescription()) &&
           VerifyField<int8_t>(verifier, VT_SEVERITY, 1) &&
           VerifyOffset(verifier, VT_LINKS) &&
           verifier.VerifyVector(links()) &&
           verifier.VerifyVectorOfStrings(links()) &&
           VerifyOffset(verifier, VT_ENTITY) &&
           verifier.VerifyString(entity()) &&
           VerifyOffset(verifier, VT_MOREINFO) &&
           verifier.VerifyVector(moreInfo()) &&
           flexbuffers::VerifyNestedFlexBuffer(moreInfo(), verifier) &&
           VerifyOffset(verifier, VT_CAUSE) &&
           verifier.VerifyVector(cause()) &&
           verifier.VerifyVectorOfTables(cause()) &&
           verifier.EndTable();
  }
  ProblemT *UnPack(const ::flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(ProblemT *_o, const ::flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static ::flatbuffers::Offset<Problem> Pack(::flatbuffers::FlatBufferBuilder &_fbb, const ProblemT* _o, const ::flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct ProblemBuilder {
  typedef Problem Table;
  ::flatbuffers::FlatBufferBuilder &fbb_;
  ::flatbuffers::uoffset_t start_;
  void add_type(::flatbuffers::Offset<::flatbuffers::String> type) {
    fbb_.AddOffset(Problem::VT_TYPE, type);
  }
  void add_title(::flatbuffers::Offset<::flatbuffers::String> title) {
    fbb_.AddOffset(Problem::VT_TITLE, title);
  }
  void add_status(int32_t status) {
    fbb_.AddElement<int32_t>(Problem::VT_STATUS, status, 0);
  }
  void add_detail(::flatbuffers::Offset<::flatbuffers::String> detail) {
    fbb_.AddOffset(Problem::VT_DETAIL, detail);
  }
  void add_instance(::flatbuffers::Offset<::flatbuffers::String> instance) {
    fbb_.AddOffset(Problem::VT_INSTANCE, instance);
  }
  void add_mainDiagnosisCode(::flatbuffers::Offset<::flatbuffers::String> mainDiagnosisCode) {
    fbb_.AddOffset(Problem::VT_MAINDIAGNOSISCODE, mainDiagnosisCode);
  }
  void add_detailedDiagnosisCode(::flatbuffers::Offset<::flatbuffers::String> detailedDiagnosisCode) {
    fbb_.AddOffset(Problem::VT_DETAILEDDIAGNOSISCODE, detailedDiagnosisCode);
  }
  void add_dynamicDescription(::flatbuffers::Offset<::flatbuffers::String> dynamicDescription) {
    fbb_.AddOffset(Problem::VT_DYNAMICDESCRIPTION, dynamicDescription);
  }
  void add_severity(comm::datalayer::Severity severity) {
    fbb_.AddElement<int8_t>(Problem::VT_SEVERITY, static_cast<int8_t>(severity), 0);
  }
  void add_links(::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<::flatbuffers::String>>> links) {
    fbb_.AddOffset(Problem::VT_LINKS, links);
  }
  void add_entity(::flatbuffers::Offset<::flatbuffers::String> entity) {
    fbb_.AddOffset(Problem::VT_ENTITY, entity);
  }
  void add_moreInfo(::flatbuffers::Offset<::flatbuffers::Vector<uint8_t>> moreInfo) {
    fbb_.AddOffset(Problem::VT_MOREINFO, moreInfo);
  }
  void add_cause(::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<comm::datalayer::Problem>>> cause) {
    fbb_.AddOffset(Problem::VT_CAUSE, cause);
  }
  explicit ProblemBuilder(::flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ::flatbuffers::Offset<Problem> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = ::flatbuffers::Offset<Problem>(end);
    fbb_.Required(o, Problem::VT_TYPE);
    fbb_.Required(o, Problem::VT_TITLE);
    return o;
  }
};

inline ::flatbuffers::Offset<Problem> CreateProblem(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    ::flatbuffers::Offset<::flatbuffers::String> type = 0,
    ::flatbuffers::Offset<::flatbuffers::String> title = 0,
    int32_t status = 0,
    ::flatbuffers::Offset<::flatbuffers::String> detail = 0,
    ::flatbuffers::Offset<::flatbuffers::String> instance = 0,
    ::flatbuffers::Offset<::flatbuffers::String> mainDiagnosisCode = 0,
    ::flatbuffers::Offset<::flatbuffers::String> detailedDiagnosisCode = 0,
    ::flatbuffers::Offset<::flatbuffers::String> dynamicDescription = 0,
    comm::datalayer::Severity severity = comm::datalayer::Severity_Emergency,
    ::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<::flatbuffers::String>>> links = 0,
    ::flatbuffers::Offset<::flatbuffers::String> entity = 0,
    ::flatbuffers::Offset<::flatbuffers::Vector<uint8_t>> moreInfo = 0,
    ::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<comm::datalayer::Problem>>> cause = 0) {
  ProblemBuilder builder_(_fbb);
  builder_.add_cause(cause);
  builder_.add_moreInfo(moreInfo);
  builder_.add_entity(entity);
  builder_.add_links(links);
  builder_.add_dynamicDescription(dynamicDescription);
  builder_.add_detailedDiagnosisCode(detailedDiagnosisCode);
  builder_.add_mainDiagnosisCode(mainDiagnosisCode);
  builder_.add_instance(instance);
  builder_.add_detail(detail);
  builder_.add_status(status);
  builder_.add_title(title);
  builder_.add_type(type);
  builder_.add_severity(severity);
  return builder_.Finish();
}

inline ::flatbuffers::Offset<Problem> CreateProblemDirect(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    const char *type = nullptr,
    const char *title = nullptr,
    int32_t status = 0,
    const char *detail = nullptr,
    const char *instance = nullptr,
    const char *mainDiagnosisCode = nullptr,
    const char *detailedDiagnosisCode = nullptr,
    const char *dynamicDescription = nullptr,
    comm::datalayer::Severity severity = comm::datalayer::Severity_Emergency,
    const std::vector<::flatbuffers::Offset<::flatbuffers::String>> *links = nullptr,
    const char *entity = nullptr,
    const std::vector<uint8_t> *moreInfo = nullptr,
    const std::vector<::flatbuffers::Offset<comm::datalayer::Problem>> *cause = nullptr) {
  auto type__ = type ? _fbb.CreateString(type) : 0;
  auto title__ = title ? _fbb.CreateString(title) : 0;
  auto detail__ = detail ? _fbb.CreateString(detail) : 0;
  auto instance__ = instance ? _fbb.CreateString(instance) : 0;
  auto mainDiagnosisCode__ = mainDiagnosisCode ? _fbb.CreateString(mainDiagnosisCode) : 0;
  auto detailedDiagnosisCode__ = detailedDiagnosisCode ? _fbb.CreateString(detailedDiagnosisCode) : 0;
  auto dynamicDescription__ = dynamicDescription ? _fbb.CreateString(dynamicDescription) : 0;
  auto links__ = links ? _fbb.CreateVector<::flatbuffers::Offset<::flatbuffers::String>>(*links) : 0;
  auto entity__ = entity ? _fbb.CreateString(entity) : 0;
  auto moreInfo__ = moreInfo ? _fbb.CreateVector<uint8_t>(*moreInfo) : 0;
  auto cause__ = cause ? _fbb.CreateVector<::flatbuffers::Offset<comm::datalayer::Problem>>(*cause) : 0;
  return comm::datalayer::CreateProblem(
      _fbb,
      type__,
      title__,
      status,
      detail__,
      instance__,
      mainDiagnosisCode__,
      detailedDiagnosisCode__,
      dynamicDescription__,
      severity,
      links__,
      entity__,
      moreInfo__,
      cause__);
}

::flatbuffers::Offset<Problem> CreateProblem(::flatbuffers::FlatBufferBuilder &_fbb, const ProblemT *_o, const ::flatbuffers::rehasher_function_t *_rehasher = nullptr);

inline ProblemT::ProblemT(const ProblemT &o)
      : type(o.type),
        title(o.title),
        status(o.status),
        detail(o.detail),
        instance(o.instance),
        mainDiagnosisCode(o.mainDiagnosisCode),
        detailedDiagnosisCode(o.detailedDiagnosisCode),
        dynamicDescription(o.dynamicDescription),
        severity(o.severity),
        links(o.links),
        entity(o.entity),
        moreInfo(o.moreInfo) {
  cause.reserve(o.cause.size());
  for (const auto &cause_ : o.cause) { cause.emplace_back((cause_) ? new comm::datalayer::ProblemT(*cause_) : nullptr); }
}

inline ProblemT &ProblemT::operator=(ProblemT o) FLATBUFFERS_NOEXCEPT {
  std::swap(type, o.type);
  std::swap(title, o.title);
  std::swap(status, o.status);
  std::swap(detail, o.detail);
  std::swap(instance, o.instance);
  std::swap(mainDiagnosisCode, o.mainDiagnosisCode);
  std::swap(detailedDiagnosisCode, o.detailedDiagnosisCode);
  std::swap(dynamicDescription, o.dynamicDescription);
  std::swap(severity, o.severity);
  std::swap(links, o.links);
  std::swap(entity, o.entity);
  std::swap(moreInfo, o.moreInfo);
  std::swap(cause, o.cause);
  return *this;
}

inline ProblemT *Problem::UnPack(const ::flatbuffers::resolver_function_t *_resolver) const {
  auto _o = std::unique_ptr<ProblemT>(new ProblemT());
  UnPackTo(_o.get(), _resolver);
  return _o.release();
}

inline void Problem::UnPackTo(ProblemT *_o, const ::flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  { auto _e = type(); if (_e) _o->type = _e->str(); }
  { auto _e = title(); if (_e) _o->title = _e->str(); }
  { auto _e = status(); _o->status = _e; }
  { auto _e = detail(); if (_e) _o->detail = _e->str(); }
  { auto _e = instance(); if (_e) _o->instance = _e->str(); }
  { auto _e = mainDiagnosisCode(); if (_e) _o->mainDiagnosisCode = _e->str(); }
  { auto _e = detailedDiagnosisCode(); if (_e) _o->detailedDiagnosisCode = _e->str(); }
  { auto _e = dynamicDescription(); if (_e) _o->dynamicDescription = _e->str(); }
  { auto _e = severity(); _o->severity = _e; }
  { auto _e = links(); if (_e) { _o->links.resize(_e->size()); for (::flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { _o->links[_i] = _e->Get(_i)->str(); } } else { _o->links.resize(0); } }
  { auto _e = entity(); if (_e) _o->entity = _e->str(); }
  { auto _e = moreInfo(); if (_e) { _o->moreInfo.resize(_e->size()); std::copy(_e->begin(), _e->end(), _o->moreInfo.begin()); } }
  { auto _e = cause(); if (_e) { _o->cause.resize(_e->size()); for (::flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { if(_o->cause[_i]) { _e->Get(_i)->UnPackTo(_o->cause[_i].get(), _resolver); } else { _o->cause[_i] = std::unique_ptr<comm::datalayer::ProblemT>(_e->Get(_i)->UnPack(_resolver)); }; } } else { _o->cause.resize(0); } }
}

inline ::flatbuffers::Offset<Problem> Problem::Pack(::flatbuffers::FlatBufferBuilder &_fbb, const ProblemT* _o, const ::flatbuffers::rehasher_function_t *_rehasher) {
  return CreateProblem(_fbb, _o, _rehasher);
}

inline ::flatbuffers::Offset<Problem> CreateProblem(::flatbuffers::FlatBufferBuilder &_fbb, const ProblemT *_o, const ::flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs { ::flatbuffers::FlatBufferBuilder *__fbb; const ProblemT* __o; const ::flatbuffers::rehasher_function_t *__rehasher; } _va = { &_fbb, _o, _rehasher}; (void)_va;
  auto _type = _fbb.CreateString(_o->type);
  auto _title = _fbb.CreateString(_o->title);
  auto _status = _o->status;
  auto _detail = _o->detail.empty() ? 0 : _fbb.CreateString(_o->detail);
  auto _instance = _o->instance.empty() ? 0 : _fbb.CreateString(_o->instance);
  auto _mainDiagnosisCode = _o->mainDiagnosisCode.empty() ? 0 : _fbb.CreateString(_o->mainDiagnosisCode);
  auto _detailedDiagnosisCode = _o->detailedDiagnosisCode.empty() ? 0 : _fbb.CreateString(_o->detailedDiagnosisCode);
  auto _dynamicDescription = _o->dynamicDescription.empty() ? 0 : _fbb.CreateString(_o->dynamicDescription);
  auto _severity = _o->severity;
  auto _links = _o->links.size() ? _fbb.CreateVectorOfStrings(_o->links) : 0;
  auto _entity = _o->entity.empty() ? 0 : _fbb.CreateString(_o->entity);
  auto _moreInfo = _o->moreInfo.size() ? _fbb.CreateVector(_o->moreInfo) : 0;
  auto _cause = _o->cause.size() ? _fbb.CreateVector<::flatbuffers::Offset<comm::datalayer::Problem>> (_o->cause.size(), [](size_t i, _VectorArgs *__va) { return CreateProblem(*__va->__fbb, __va->__o->cause[i].get(), __va->__rehasher); }, &_va ) : 0;
  return comm::datalayer::CreateProblem(
      _fbb,
      _type,
      _title,
      _status,
      _detail,
      _instance,
      _mainDiagnosisCode,
      _detailedDiagnosisCode,
      _dynamicDescription,
      _severity,
      _links,
      _entity,
      _moreInfo,
      _cause);
}

inline const comm::datalayer::Problem *GetProblem(const void *buf) {
  return ::flatbuffers::GetRoot<comm::datalayer::Problem>(buf);
}

inline const comm::datalayer::Problem *GetSizePrefixedProblem(const void *buf) {
  return ::flatbuffers::GetSizePrefixedRoot<comm::datalayer::Problem>(buf);
}

inline Problem *GetMutableProblem(void *buf) {
  return ::flatbuffers::GetMutableRoot<Problem>(buf);
}

inline comm::datalayer::Problem *GetMutableSizePrefixedProblem(void *buf) {
  return ::flatbuffers::GetMutableSizePrefixedRoot<comm::datalayer::Problem>(buf);
}

inline bool VerifyProblemBuffer(
    ::flatbuffers::Verifier &verifier) {
  return verifier.VerifyBuffer<comm::datalayer::Problem>(nullptr);
}

inline bool VerifySizePrefixedProblemBuffer(
    ::flatbuffers::Verifier &verifier) {
  return verifier.VerifySizePrefixedBuffer<comm::datalayer::Problem>(nullptr);
}

inline void FinishProblemBuffer(
    ::flatbuffers::FlatBufferBuilder &fbb,
    ::flatbuffers::Offset<comm::datalayer::Problem> root) {
  fbb.Finish(root);
}

inline void FinishSizePrefixedProblemBuffer(
    ::flatbuffers::FlatBufferBuilder &fbb,
    ::flatbuffers::Offset<comm::datalayer::Problem> root) {
  fbb.FinishSizePrefixed(root);
}

inline std::unique_ptr<comm::datalayer::ProblemT> UnPackProblem(
    const void *buf,
    const ::flatbuffers::resolver_function_t *res = nullptr) {
  return std::unique_ptr<comm::datalayer::ProblemT>(GetProblem(buf)->UnPack(res));
}

inline std::unique_ptr<comm::datalayer::ProblemT> UnPackSizePrefixedProblem(
    const void *buf,
    const ::flatbuffers::resolver_function_t *res = nullptr) {
  return std::unique_ptr<comm::datalayer::ProblemT>(GetSizePrefixedProblem(buf)->UnPack(res));
}

}  // namespace datalayer
}  // namespace comm

#endif  // FLATBUFFERS_GENERATED_PROBLEM_COMM_DATALAYER_H_
